
#ifndef __USB_PD_H_
#define __USB_PD_H_


#include <math.h>
#include <stdio.h>
#include <intrins.h>
#include "REG_MG82F6P32.H"
#include "typedef.h"
#include "config.H"
#include <string.h>
#include "ADC.h"


// USB Port States
typedef enum 
{
    UNKNOWN_DEVICE,
    DEFAULT_USB_CC1,
    POWER5V_1P5A_CC1,
    POWER5V_3A_CC1,
    DEFAULT_USB_CC2,
    POWER5V_1P5A_CC2,
    POWER5V_3A_CC2,
} USB_Port_StatesDef;


// USB PD States
typedef enum 
{
    PD_STATE_SNK_DISCONNECTED,
    PD_STATE_SNK_DISCOVERY,
    PD_STATE_SNK_REQUESTED,
    PD_STATE_SNK_TRANSITION,
    PD_STATE_SNK_READY,
    PD_STATE_SOFT_RESET,
    PD_STATE_HARD_RESET_SEND,
} USB_PD_StatesDef;
    

typedef enum 
{
    IDLE,
    TRANSFER,
    RECEIVE,
}PD_Communication_StatusDef;

typedef enum 
{
    MODE_5V,
    MODE_9V,
    MODE_12V,
    MODE_15V,
    MODE_20V,
}PD_Triggermode_StatusDef;



typedef enum 
{
 MSG_TYPE,    
 DATA_ROLE,   
 SPEC_REV,        
 POWER_ROLE,  
 MESSAGEID,   
 DATA_OBJECTS, 
 EXTENDED,    
}PD_header_FieldDef;

typedef enum
{
    UN_EXTENDED=0x00,
    Source,
} PD_HeaderExd_Role;

typedef enum
{
    SINK = 0x00,
    SOURCE = 0x01,
} PD_HeaderPower_Role;
typedef enum
{
    V10 = 0x00,
    V20 = 0x40,
    V30 = 0x80,
} PD_HeaderSpec_Revision;

typedef enum
{
    UFP = 0x00, 
    DFP = 0x20,
} PD_HeaderPort_Data;

// Control Message define
typedef enum
{
    PD_RESERVED = 0X00,
    PD_GOODCRC = 0X01,
    PD_GOTOMIN = 0X02,
    PD_ACCEPT = 0X03,
    PD_REJECT = 0X04,
    PD_PING = 0X05,
    PD_PS_RDY = 0X06,
    PD_GET_SOURCE_CAP = 0x07,
    PD_GET_SINK_CAP = 0x08,
    PD_DR_SWAP = 0x09,
    PD_PR_SWAP = 0x0A,
    PD_VCONN_SWAP = 0x0B,
    PD_WAIT = 0x0C,
    PD_SOFT_RESET = 0x0D,
    PD_DATA_RESET = 0x0E,
    PD_DATA_RESET_COMPLETE = 0x0F,
    PD_NOT_SUPPORTED = 0x10,
    PD_GET_SOURCE_CAP_EXTENDED = 0x11,
    PD_GET_STATUS = 0x12,
    PD_FR_SWAP = 0x13,
    PD_GET_PPS_STATUS = 0x14,
    PD_GET_COUNTRY_CODES = 0x15,
    PD_GET_SINK_CAP_EXTENDED = 0x16,
    PD_GET_SOURCE_INFO = 0x17,
    PD_GET_REVISION = 0x18,
} PD_ControlMessageType_Def;

// Data Message define
typedef enum
{
    //RESERVED=0x00,
    PD_SOURCE_CAPABILITIES = 0x01,
    PD_REQUEST = 0x02,
    PD_BIST = 0x03,
    PD_SINK_CAPABILITIES = 0x04,
    PD_BATTERY_STATUS = 0x05,
    PD_ALERT = 0x06,
    PD_GET_COUNTRY_INFO = 0x07,
    PD_ENTER_USB = 0x08,
    PD_EPR_REQUEST = 0x09,
    PD_EPR_MODE = 0x0A,
    SOURCE_INFO = 0x0B,
    PD_REVISION = 0x0C,
    PD_VENDOR_DEFINED = 0x0F,
} PD_DataMessageType_Def;

// Source PDO Power type define
typedef enum
{
    RESERVED=0x00,
    FIXED_SUPPLY = 0x01,
    BATTERY = 0x02,
    VARIABLE_SUPPLY = 0x03,
    AUGMENTED_POWER = 0x04,

} PD_PowerType_Def;

// Sink Capability type define
typedef enum
{
    DUAL_ROLE_POWER= 0,
    HIGHER_CAP= 1,
    UNCON_POWER = 0,
    USB_COMM = 0x00,

} PD_SINKCapType_Def;


#define CC1_PIN ADC_AIN3
#define CC2_PIN ADC_AIN1







#define VRa_MAX        0.15/3.3*4096 
#define DEFAULT_USB_MAX  0.61/3.3*4096  //0xba
#define DEFAULT_USB_MIN  0.25/3.3*4096 //0x136
#define POWER_1P5A_MIN  0.7/3.3*4096    //0x364    
#define POWER_1P5A_MAX  (1.23/3.3*4096)-1   //0x59f
#define POWER_3A_MIN  1.23/3.3*4096     //0x659    
#define POWER_3A_MAX  2.04/3.3*4096     //0x9e4    
#define VBUS_MIN  3.67/6/3.3*4096/6      // div6, Resistor divider (10K & 51K) Type C spec (transition to Unattached.SNK when VBUS falls below 3.67 V.)    

#define GIVEBACK 0x08000000
#define SINK_OPERATIONAL_CURRENT 0x0000012C  //sink operational Current in 10mA units(3A)
#define SINK_OPERATIONAL_VOLTAGE 0x0002D000  //sink voltage in 50mV units(9V/50mV=180)
#define SINK_FIXED_SUPPLY       0x00000000        //00 
#define SINK_DUAL_ROLE_POWER    0x00000000        //0 or 0x20000000
#define SINK_HIGHER_CAP         0x10000000        //The Higher(5v) Capability bit Shall be set.
#define SINK_UNCON_POWER        0x00000000        //0x08000000 if AC supply supply, e.g., a wall wart,,Unconstrained Power bits set.
#define SINK_USB_COMM           0x00000000        //USB Communications not support.




//Timer
#define PD_TIME_SINK_REQUEST     100 /* Wait 100ms before next request */



//Flags
#define PD_FLAGS_NO_DETECT_SOP     (1 << 0) /* Identify SOP */
#define PD_FLAGS_RX_PACKET         (1 << 1) /* new PD packet received */
#define PD_TX_RETRY                (1 << 2) /* non received goodcrc */
#define PD_FLAGS_PREVIOUS_PD_CONN  (1 << 3) /* previously PD connected */
#define PD_FLAGS_EXPLICIT_CONTRACT (1 << 4) /* explicit pwr contract in place */
#define PD_FLAGS_VBUS_NEVER_LOW    (1 << 5) /* VBUS input has never been low */
#define PD_FLAGS_VBUS_PR_RDY       (1 << 6) /* USB PD VBUS output ready flag */
#define PD_FLAGS_SEND_HARD_RESET   (1 << 7) /* USB PD send hard reset flag */




#define __DRV_END45_mode(__MODE__)\
    SFRPI = AUXR12_Page;\
    (__MODE__==BMC_4bto5b?(AUXR12  &= 0xF7):(AUXR12  |= 0x08));\

#define Clear_mTime TL0 = 0; 

extern bit Support_5V_Flag;
extern bit Support_9V_Flag;
extern bit Support_12V_Flag;
extern bit Support_15V_Flag;
extern bit Support_20V_Flag;
extern bit Flag_1ms;
extern bit Flag_10ms;
extern bit Flag_500ms;
extern bit Flag_select_mode;
extern bit sel_keystate,set_keystate;
extern bit pd_new_request;
extern DWTYPE PD_Source_PDO[7];   //Source support Power Data Object
extern U8 PD_TX_Field;
extern U8 PD_TX_Count;
extern U8 PDO_9V_index;
extern U8 PDO_12V_index;
extern U8 PDO_15V_index;
extern U8 PDO_20V_index;
extern xdata U8 PD_RXdata[];
extern U8 PD_TXdata[34];
extern U8 PD_Communication_Status;
extern U8 CCDebounce;
extern U8 DetectDevice;
extern U8 USB_Port_Status;
extern U8 PD_RX_Field;
extern U16 Timer_ms;
extern U8 Timer_10ms;
extern U8 Timer_500ms;
extern U8 Select_mode;
extern U8 Timeout_select;
extern U8 SelKeyDebounce,SetKeyDebounce;
extern U8 Vbus_onDebounce,Vbus_offDebounce;
extern U8 pdo_index;
extern U8 Header_Highbyte,Header_Lowbyte;
extern U8 pd_messageid;
extern U8 retry_counter;
extern U16 pd_flags;
extern U8 Set_volt;
extern U8 pd_state;
U8 get_header_field ( U8 FIELD );
extern U16 ADC_GetConversionData();
extern void Initial_GPIO ( void );
extern void Run_USBPD();
extern void led_state();
extern void key_state();
extern void select_next_mode();
extern void CC_bus_release();
extern void CC_bus_latch();
extern void pd_transmit_packet();
void pd_send_control_msg(U8 MsgType);
extern void pd_send_data_msg(U8 MsgType);
extern void pd_set_state(U8 next_state);
#endif

